%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         NATURE INSPIRED TOOLBOX  SUPPORT FILE
% ======================================================
%   USAGE :
%         1. nitgui(action)
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function nitgui(action, oldName, newName)

if strcmp(action,'#initialize')
    % Create the main menubar items File Edit View common to every editor.
    % Create the File main menu item, and its submenus, then call createmenu to create
    % the Edit, View and Options mainmenu items.
    figNit = watchon;
    oldnit=get(figNit,'UserData');
    nit=oldnit{1};
    figNit=findobj(0, 'Type', 'Figure', 'Name', ['NIT Editor: ' nit.Name]);

    % Main menu bar item File -------------------------------------------------
    fileHndl=uimenu(figNit,'Label','File','Accelerator','F');
    N = uimenu('Parent', fileHndl,...
        'Label', 'New',...
        'Separator','off');
    uimenu('Parent', N,...
        'Label', 'PSO',...
        'Callback', 'nitgui #filePSO');
    uimenu('Parent', N,...
        'Label', 'GA',...
        'Callback', 'nitgui #fileGA');
    uimenu('Parent', N,...
        'Label', 'ACO',...
        'Callback', 'nitgui #fileACO');
    uimenu('Parent', N,...
        'Label', 'BBO',...
        'Callback', 'nitgui #fileBBO');
    O = uimenu('Parent', fileHndl,...
        'Label', 'Open',...
        'Separator','off',...
        'Accelerator', 'O',...
        'Tag', 'fileopen',...
        'Callback', 'nitgui #fileopen');
    S = uimenu('Parent', fileHndl,...
        'Label', 'Save',...
        'Separator','on',...
        'Accelerator', 'S',...
        'Tag', 'filesave',...
        'Callback', 'nitgui #filesave');
    W = uimenu('Parent', fileHndl,...
        'Label', 'Export to WS...',...
        'Separator','off',...
        'Accelerator', 'W',...
        'Tag', 'fileexport',...
        'Callback', 'nitgui #fileexport');
    X = uimenu('Parent', fileHndl,...
        'Label', 'Close',...
        'Separator','on',...
        'Accelerator', 'X',...
        'Tag', 'fileclose',...
        'Callback', 'nitgui #fileclose');

    % Main menu bar item Edit---------------------------------------------------
    Handles.optionHndl=uimenu(figNit, 'Label', 'Option', 'Accelerator','O');
    I = uimenu('Parent', Handles.optionHndl,...
        'Label', 'Import...',...
        'Separator','off',...
        'Accelerator', 'I',...
        'Tag', 'optionimport',...
        'Callback', 'nitgui #optionimport');
    P = uimenu('Parent', Handles.optionHndl,...
        'Label', 'Plot(s)',...
        'Separator','on',...
        'Accelerator', 'P',...
        'Tag', 'optionplot');
    uimenu('Parent', P,...
        'Label', 'Best Fitness',...
        'Separator','off',...
        'Tag', 'plotbest',...
        'Callback', 'nitgui #plotbest');
    uimenu('Parent', P,...
        'Label', 'Average Fitness',...
        'Separator','off',...
        'Tag', 'plotbest',...
        'Callback', 'nitgui #plotavg');

    % Main menu bar item View------------------------------------------------------
    Handles.helpHndl=uimenu(figNit, 'Label', 'Help', 'Accelerator','H');
    PSO = uimenu('Parent', Handles.helpHndl,...
        'Label', 'PSO',...
        'Separator','off',...
        'Tag', 'helppso',...
        'Callback', 'nitgui #helppso');
    NIT = uimenu('Parent', Handles.helpHndl,...
        'Label', 'About NIT',...
        'Separator','on',...
        'Tag', 'helpnit',...
        'Callback', 'nitgui #helpnit');
    Handles.viewHndl=0;
%     Handles.viewHndl=uimenu('Parent', figNit,'Label', 'View', 'Tag', 'viewmenu');

    % Populate the fuzzy editor specific submenu items
%     nitmenu(figNit, tag, Handles);

elseif strcmp(action,'#filePSO')
    %   NEW PSO FILE
    %   ===================================
    newNit=newnit('Untitled', 'PSO');
    nitool(newNit);

elseif strcmp(action,'#fileGA')
    %   NEW GA FILE
    %   ===================================
    newNit=newnit('Untitled', 'GA');
    nitool(newNit);
    
elseif strcmp(action,'#fileopen')
    %   OPEN EXISTING FILE
    %   ===================================
    [fileName, pathName] = uigetfile( ...
        {'*.PSO; *.GA; *.ACO; *.ACO', 'NIT Files (*.PSO,*.GA,*.ACO,*.BBO)';
        '*.PSO', 'Particle Swarm Optimization files (*.PSO)'; ...
        '*.GA','Genetic Algorithms file (*.GA)'; ...
        '*.ACO','Ant Colony Optimization files (*.ACO)'; ...
        '*.BBO','Biogeoraphical Based Optimization (*.BBO)'; ...
        '*.*',  'All Files (*.*)'}, ...
        'Open an NIT File');
    ExstNit = rdnit(fileName);
    nitool(ExstNit);

elseif strcmp(action,'#filesave')
    %   SAVE AS FILE ON DISK
    %   ===================================
    fig =watchon;
    thisnit{1} = get(fig, 'UserData');
    nit = thisnit{1};
    figNit = findobj(0, 'Type', 'Figure', 'Name', ['NIT Editor: ' nit.Name]);
    figPlot = findobj(0, 'Type', 'Figure', 'Name', ['NIT Plots: ' nit.Name]);
    nit = wrnit(nit);
    ['NIT Editor: ' nit.Name]
    get(figNit, 'Name')
    set(figNit, 'Name', ['NIT Editor: ' nit.Name], 'UserData', nit);
    set(figPlot, 'Name', ['NIT Plots: ' nit.Name], 'UserData', nit);
    watchoff(fig);
    
elseif strcmp(action,'#fileexport')
    %   EXPORT TO WORKSPACE
    %   ===================================
    figNit = watchon;
    nit = get(figNit, 'UserData');
    [p name x v] = fileparts(nit.Name);
    assignin('base', name, nit);
    watchoff(figNit);

elseif strcmp(action,'#fileclose')
    %   CLOSE EXISTING SYSTEM
    %====================================
    %     delete(gcf)

    figNit = gcf;
    allnit{1} = get(figNit,'UserData');
    nit = allnit{1};

%     nit=get(figNit, 'UserData');
    nameList=[ ...
        'NIT Editor      '
        'NIT Plots       '
        'About NI Toolbox'];
    nitName=nit.Name;
    visFigList=[];
    invisFigList=[];
    
    abtNIT = findobj(0, 'Type', 'Figure', 'Name', ['About NI Toolbox: ' nit.Name]);
    close(abtNIT);
    % See who's left onscreen
    for count=1:size(nameList, 1)
        name=deblank(nameList(count,:));
        visFigList=[visFigList findobj(0, 'Type', 'figure', 'Name', [name ': ' nitName], 'Visible', 'on')'];
        invisFigList=[invisFigList findobj(0, 'Type', 'figure', 'Name', [name ': ' nitName], 'Visible', 'off')'];
    end

    if length(visFigList)==1 | length(visFigList)==2,
        % This is the last visible relative. Closing this will mean losing data.
        nittemp{1}=nit; %make a cell
        svdlg(nittemp, [visFigList invisFigList]);
    else
        set(figNit, 'Visible', 'off');
    end

elseif strcmp(action,'#optionimport')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    'import options'

elseif strcmp(action,'#strfile')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    StrFile = get(CObj, 'String');
    nit.String.File= StrFile;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#strsheet')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    StrSheet = get(CObj, 'String');
    nit.String.Sheet = StrSheet;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#strrange')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    StrRange = get(CObj, 'String');
    nit.String.Range = StrRange;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#chkfile')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    ChkFile = get(CObj, 'String');
    nit.Checks.File = ChkFile;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#chksheet')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    ChkSheet = get(CObj, 'String');
    nit.Checks.Sheet = ChkSheet;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#chkrange')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    ChkRange = get(CObj, 'String');
    nit.Checks.Range = ChkRange;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#psize')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    PSizeStr = get(CObj, 'String');
    nit.Swarm.PSize = str2num(PSizeStr);
    set(figNit, 'UserData', nit);
    watchoff(figNit);
    
elseif strcmp(action,'#psomodel')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    figNit = watchon;
    nit = get(figNit, 'UserData');
    psoM = findobj(figNit, 'Tag', 'PSOModel');
    nsize = findobj(figNit, 'Tag', 'NSize');
    topo = findobj(figNit, 'Tag', 'Topo');
    PltL = findobj(figNit, 'Tag', 'plotLBest'); 
    if get(psoM, 'Value')==2
        nit.Swarm.Model = 'LBest';
        set(nsize, 'Enable', 'On');
        set(topo, 'Enable', 'On');
        set(PltL, 'Enable', 'On')
    else
        nit.Swarm.Model = 'GBest';
        set(nsize, 'Enable', 'Off');
        set(topo, 'Enable', 'Off');
        set(PltL, 'Enable', 'Off');
    end
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#nsize')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    NSizeVal = get(CObj, 'Value');
    if NSizeVal == 1
        nit.Swarm.NSize = 1;
    elseif NSizeVal == 2
        nit.Swarm.NSize = 2;
    elseif NSizeVal == 3
        nit.Swarm.NSize = 3;
    end
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#topology')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    TopoVal = get(CObj, 'Value');
    if TopoVal == 1
        nit.Swarm.Topology = 'Ring';
    elseif TopoVal == 2
        nit.Swarm.Topology = 'Linear';
    elseif TopoVal == 3
        nit.Swarm.Topology = 'Wheel';
    end
    set(figNit, 'UserData', nit);
    watchoff(figNit);
    
elseif strcmp(action,'#trgfile')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    TrgFile = get(CObj, 'String');
    nit.Objective.File = TrgFile;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#trgsheet')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    TrgSheet = get(CObj, 'String');
    nit.Objective.Sheet = TrgSheet;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#trgrange')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    TrgRange = get(CObj, 'String');
    nit.Objective.Range = TrgRange;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#FitFun')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    FuncStr = get(CObj, 'String');
    nit.Objective.Function = FuncStr;
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#C1')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    C1 = get(CObj, 'String');
    nit.Parameter.C1 = str2num(C1);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#C2')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    C2 = get(CObj, 'String');
    nit.Parameter.C2 = str2num(C2);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#C3')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    C3 = get(CObj, 'String');
    nit.Parameter.C3 = str2num(C3);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#velo')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    Vel = get(CObj, 'String');
    nit.Parameter.MaxVelocity = str2num(Vel);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#chi')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    Chi = get(CObj, 'String');
    nit.Parameter.Chi = str2num(Chi);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#WtOption')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    figNit = watchon;
    nit = get(figNit, 'UserData');
    WtOp = findobj(figNit, 'Tag', 'WtOpt');
    EndW = findobj(figNit, 'Tag', 'NdWt');
    if get(WtOp, 'Value')==2
        set(EndW, 'Enable', 'On');
        nit.Parameter.WeightOption = 'Variable';
    else
        set(EndW, 'Enable', 'Off');
        nit.Parameter.WeightOption = 'Fixed';
    end
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#startwt')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    StartWt = get(CObj, 'String');
    nit.Parameter.StartWeight = str2num(StartWt);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#endwt')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    EndWt = get(CObj, 'String');
    nit.Parameter.EndWeight = str2num(EndWt);
    set(figNit, 'UserData', nit);
    watchoff(figNit);


elseif strcmp(action,'#nochange')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    NCItr = get(CObj, 'String');
    nit.Terminate.NoChange = str2num(NCItr);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#objval')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    ObjVal = get(CObj, 'String');
    nit.Terminate.Goal = str2num(ObjVal);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#maxitr')
    figNit = watchon;
    nit = get(figNit, 'UserData');
    CObj = gcbo;
    MxItr = get(CObj, 'String');
    nit.Terminate.MaxIterations = str2num(MxItr);
    set(figNit, 'UserData', nit);
    watchoff(figNit);

elseif strcmp(action,'#nitplots')
    %   NIT PLOT OPTIONS
    %====================================
    figNit = findobj(0, 'Type', 'Figure', 'Tag', 'nitFig');
    nit = get(figNit, 'UserData');
    GHdl = findobj(figNit, 'Tag', 'plotGBest');
    G = get(GHdl, 'Value');
    AHdl = findobj(figNit, 'Tag', 'plotAvg');
    A = get(AHdl, 'Value');
    LHdl = findobj(figNit, 'Tag', 'plotLBest');
    L = get(LHdl, 'Value');
    Val = [G A L];
    figPlot = findobj(0, 'Type', 'Figure', 'Name', 'NIT Plots', 'Tag', 'nitPlot');
    
    Gline = findobj(figPlot, 'Type', 'Line', 'Color', 'r');
    if G == 1, set(Gline, 'Visible', 'On'); nit.Plot.GBest = 1;
    else set(Gline, 'Visible', 'Off'); nit.Plot.GBest = 0; end
    
    Aline = findobj(figPlot, 'Type', 'Line', 'Color', 'b');
    if A == 1, set(Aline, 'Visible', 'On'); nit.Plot.Average = 1;
    else set(Aline, 'Visible', 'Off'); nit.Plot.Average = 0; end
    
    Lline = findobj(figPlot, 'Type', 'Line', 'Color', 'g');
    if L == 1, set(Lline, 'Visible', 'On'); nit.Plot.LBest = 1;
    else set(Lline, 'Visible', 'Off'); nit.Plot.LBest = 0; end
    
    if  sum(Val)~=0, set(figPlot, 'Visible', 'On');
    else set(figPlot, 'Visible', 'Off'); end
    set(figNit, 'UserData', nit);
    
elseif strcmp(action,'#plotavg')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    'plot average fitness'
    'enable / disable'

elseif strcmp(action,'#helppso')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    'help PSO'
    
elseif strcmp(action,'#helpnit')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    figNit = watchon;
    nit = get(figNit, 'UserData');
    aboutNIT(nit);
    watchoff(figNit);
    
elseif strcmp(action,'#lic')
    %   IMPORT SYSTEM OPTIONS
    %====================================
    winopen('license.txt');

elseif strcmp(action,'#run')
% close all
    %   RUN EVOLUTION WHEN [RUN] BUTTON PRESSED
    %====================================
    figNit = watchon;
%     figNit = findobj(0, 'Type', 'Figure', 'Name', ['NIT Editor: ' nit.Name]);
    nit = get(figNit, 'UserData');
    watchoff(figNit);
    
    PopSiz = nit.Swarm.PSize;
    PrtStr = xlsread(nit.String.File, nit.String.Sheet, nit.String.Range);
    PrtChk = xlsread(nit.Checks.File, nit.Checks.Sheet, nit.Checks.Range);

    ipop = genrandpop(PopSiz, PrtStr, PrtChk);
    global RESULT
    RESULT = runnit(nit, ipop);
    

    % END OF NITGUI
end
